' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Collections.Generic
Imports System.Data

''' <summary>
''' Klasa ShopManager odpowiada za zarzdzanie koszykiem i katalogiem produktw.
''' </summary>
Public Class ShopManager

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy ShopManager.
  ''' </summary>
  Private Sub New()
  End Sub

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Waciwo ShoppingCart zapewnia dostp do koszyka zapisanego w stanie sesji.
  ''' </summary>
  Public Shared ReadOnly Property ShoppingCart() As ShoppingCart
    Get
      If HttpContext.Current.Session("ShoppingCart") Is Nothing Then
        HttpContext.Current.Session("ShoppingCart") = New ShoppingCart()
      End If
      Return CType(HttpContext.Current.Session("ShoppingCart"), ShoppingCart)
    End Get
  End Property

#End Region

#Region "Metody publiczne"

#Region "Metody do pracy z koszykiem"

  ''' <summary>
  ''' Zapewnia skrt do kolekcji Items. Jest uywana w konktrolkach ObjectDataSource, ktre nie mog mie bezporedniego dostpu kolekcji Items obiektu ShoppingCart.
  ''' </summary>
  Public Shared Function GetShoppingCartItems() As List(Of OrderedProduct)
    Return ShoppingCart.Items
  End Function

  ''' <summary>
  ''' Dodaje nowy produkt do koszyka.
  ''' </summary>
  ''' <param name="theProduct"><see cref="Product">Produkt</see>, ktry ma by dodany do koszyka.</param>
  Public Shared Sub AddProductToCart(ByVal theProduct As Product)
    ShopManager.ShoppingCart.Add(theProduct)
  End Sub

  '''' <summary>
  '''' Aktualizuje OrderedProduct istniejcy w koszyku.
  '''' </summary>
  ''' <param name="newQuantity">NOwa ilo zamawianego produktu.</param>
  ''' <param name="id">Identyfikator obiektu OrderedProduct w koszyku.</param>
  ''' <remarks></remarks>
  Public Shared Sub UpdateProductInCart(ByVal newQuantity As Integer, ByVal id As Guid)
    ShoppingCart.Update(newQuantity, id)
  End Sub

  ''' <summary>
  ''' Usuwa pozycj z koszyka.
  ''' </summary>
  ''' <param name="id">Unikalny identyfikator OrderedProduct, ktry ma by usunity.</param>
  Public Shared Sub RemoveProductFromCart(ByVal id As Guid)
    ShoppingCart.Remove(id)
  End Sub

  ''' <summary>
  ''' Skada zamwienie i zwraca nowy identyfikator zamwienia.
  ''' </summary>
  ''' <param name="theCustomer">Object Customer zawierajacy dane uytkownika.</param>
  Public Shared Function FinalizeOrder(ByVal theCustomer As Customer) As Integer
    If ShoppingCart.Count > 0 Then
      Dim orderId As Integer = ShopManagerDB.FinalizeOrder(ShoppingCart, theCustomer)
      Helpers.SendConfirmationMessage(ShoppingCart, orderId, Membership.GetUser().Email)
      ShoppingCart.Clear()
      Return orderId
    Else
      Throw New ArgumentException("Nie mona zapisa zamwienia przy pustym koszyku")
    End If
  End Function

#End Region

#Region "Metody do zarzdzania produktami"

  ''' <summary>
  ''' Zwraca silnie typowan list produktw w okrelonej kategorii.
  ''' </summary>
  ''' <param name="theCategoryId">Identyfikator kategorii produktw.</param>
  ''' <returns>Generyczna lista produktw (List(Of Product)).</returns>
  Public Shared Function GetProductList(ByVal theCategoryId As Integer) As List(Of Product)
    Dim productList As List(Of Product) = New List(Of Product)
    Return ShopManagerDB.GetProducts(theCategoryId)
  End Function

  ''' <summary>
  ''' Zwraca pojedynczy egzemplarz produktu wskazywanego przez Id, lub Nothing, jeli produkt nie zosta znaleziony.
  ''' </summary>
  ''' <param name="theProductId">Identyfikator pruduktu w bazie danych.</param>
  ''' <returns>Produkt, jeli zostal znaleziony lub Nothing w przeciwnym wypadku.</returns>
  Public Shared Function GetProduct(ByVal theProductId As Integer) As Product
    Return ShopManagerDB.GetProduct(theProductId)
  End Function

  ''' <summary>
  ''' Wstawia produkt do bazy danych.
  ''' </summary>
  ''' <param name="theProduct">Nowy produkt do wstawienia.</param>
  Public Shared Sub InsertProduct(ByVal theProduct As Product)
    If HttpContext.Current.User.IsInRole("Administrator") Then
      ShopManagerDB.InsertProduct(theProduct)
    End If
  End Sub

  ''' <summary>
  ''' Usuwa produkt z bazy danych.
  ''' </summary>
  ''' <param name="theProduct">Produkt do usunicia.</param>
  Public Shared Sub DeleteProduct(ByVal theProduct As Product)
    If HttpContext.Current.User.IsInRole("Administrator") Then
      ShopManagerDB.DeleteProduct(theProduct)
    End If
  End Sub

  ''' <summary>
  ''' Zwraca DataSet z kolumnami Id i Description zawierajcy dostpne kategorie produktw.
  ''' </summary>
  ''' <returns>DataSet z danymi kategoriami.</returns>
  Public Shared Function GetProductCategories() As DataSet
    If HttpContext.Current.Cache("CategoryList") IsNot Nothing Then
      Return CType(HttpContext.Current.Cache("CategoryList"), DataSet)
    Else
      Dim myDataSet As DataSet = ShopManagerDB.GetProductCategories()
      HttpContext.Current.Cache.Insert("CategoryList", myDataSet, Nothing, DateTime.Now.AddMinutes(30), TimeSpan.Zero)
      Return myDataSet
    End If
  End Function
#End Region

#End Region

End Class
